/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.item;

import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.block.entity.UpgradeableBlockEntity;
import cy.jdkdigital.productivebees.init.ModItems;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class UpgradeItem
extends Item {
    public UpgradeItem(Item.Properties properties) {
        super(properties);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, world, tooltip, flagIn);
        if (stack.m_41720_().equals(ModItems.UPGRADE_FILTER.get())) {
            return;
        }
        String upgradeType = stack.m_41720_().getRegistryName().m_135815_();
        double value = 0.0;
        switch (upgradeType) {
            case "upgrade_productivity": {
                value = (Double)ProductiveBeesConfig.UPGRADES.productivityMultiplier.get();
                break;
            }
            case "upgrade_breeding": {
                value = (Double)ProductiveBeesConfig.UPGRADES.breedingChance.get();
                break;
            }
            case "upgrade_time": {
                value = (Double)ProductiveBeesConfig.UPGRADES.timeBonus.get();
            }
        }
        tooltip.add((Component)new TranslatableComponent("productivebees.information.upgrade." + upgradeType, new Object[]{(int)(value * 100.0)}).m_130940_(ChatFormatting.GOLD));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockEntity tileEntity;
        Level world = context.m_43725_();
        if (!world.f_46443_ && context.m_43723_() != null && context.m_43723_().m_6144_() && context.m_43722_().m_41720_() instanceof UpgradeItem && (tileEntity = world.m_7702_(context.m_8083_())) instanceof UpgradeableBlockEntity && ((UpgradeableBlockEntity)tileEntity).acceptsUpgrades()) {
            AtomicBoolean hasInsertedUpgrade = new AtomicBoolean(false);
            ((UpgradeableBlockEntity)tileEntity).getUpgradeHandler().ifPresent(handler -> {
                for (int slot = 0; slot < handler.getSlots(); ++slot) {
                    if (!handler.getStackInSlot(slot).equals(ItemStack.f_41583_)) continue;
                    handler.insertItem(slot, context.m_43722_().m_41777_(), false);
                    hasInsertedUpgrade.set(true);
                    break;
                }
            });
            if (hasInsertedUpgrade.get()) {
                if (!context.m_43723_().m_7500_()) {
                    context.m_43722_().m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6225_(context);
    }
}

